/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalBTT = Object.create(STBModule.prototype);

STBGlobalBTT.name		= "GlobalBackToTop";
STBGlobalBTT.container	= "#back-to-top";
STBGlobalBTT.wait		= 600;
STBGlobalBTT.speed		= 1000;
STBGlobalBTT.animation  = "linear";
STBGlobalBTT.animateIn	= "animated fadeInRightSmall";
STBGlobalBTT.animateOut	= "animated fadeOutRightSmall";
STBGlobalBTT.isVisible  = false;

STBGlobalBTT.runOnReady = function () {
	var button = jQuery(STBGlobalBTT.container);

	if (!button.length){
		return false;
	}

	STBGlobalBTT.animateIn = STBUtils.attrDefaultValue(button.attr("data-in"), STBGlobalBTT.animateIn);
	STBGlobalBTT.animateOut = STBUtils.attrDefaultValue(button.attr("data-out"), STBGlobalBTT.animateOut);
	STBGlobalBTT.speed = STBUtils.attrDefaultValue(button.attr("data-time"), STBGlobalBTT.speed);
	STBGlobalBTT.animation = STBUtils.attrDefaultValue(button.attr("data-anim"), STBGlobalBTT.animation);

	if (STBModuleTopintro.pageHasTopIntro()){
		STBGlobalBTT.wait += jQuery(window).height();
	}

	button.click(function(e) {
		e.preventDefault();

		if (jQuery("body").hasClass("is-scrolling")) {
			return false;
		}

		jQuery("body").addClass("is-scrolling");
			
		//check if full page is enabled
		if (jQuery(".page-wrapper").length) {
			var cont = jQuery(".page-wrapper");
		} else {
			var cont = jQuery("html, body");
		}

	


		try {
			

			//for EDGE
			if (!cont.scrollTop()) {
				var screens = jQuery(document).height() / jQuery(window).height();
			} else {
				var screens = cont.scrollTop() / jQuery(window).height();
			}

			speed = parseInt(STBGlobalBTT.speed * screens);

			cont.stop().animate(
				{
					scrollTop: 0
				},
				{	
					duration	: "1200",//speed,
					easing		: "linear", //STBGlobalBTT.animation,
//					queue		: false,
					complete	: function() {
											
						setTimeout(
							function() {
								jQuery("body").removeClass("is-scrolling");
							},
							speed
						);
					}
				}
				
			);
			
		}
		catch (e){
			getStack(0,e);
		}

	});
}

STBGlobalBTT.runOnScroll = function () {

	if (jQuery(STBGlobalBTT.container).length > 0) {

		if (jQuery(".page-wrapper").length) {
			var cont = jQuery(".page-wrapper");
		} else {
			var cont = jQuery(window);
		}

		if (cont.scrollTop() > STBGlobalBTT.wait) {			
			if (!STBGlobalBTT.isVisible){
				jQuery(STBGlobalBTT.container).show().removeClass(STBGlobalBTT.animateOut).addClass(STBGlobalBTT.animateIn);
				STBGlobalBTT.isVisible  = true;
			}
		} else {

			if (STBGlobalBTT.isVisible){
				jQuery(STBGlobalBTT.container).removeClass(STBGlobalBTT.animateIn).addClass(STBGlobalBTT.animateOut);
				STBGlobalBTT.isVisible  = false;
			}
		}
	}
}

site.registerModule(STBGlobalBTT);